/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.router;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskNumericProperty;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskPropertyPanel;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.VWTaskTabbedPane;
import filenet.vw.apps.taskman.router.VWRouterNode;
import filenet.vw.apps.taskman.router.VWRouterNodeConvertTwo;
import filenet.vw.apps.taskman.router.resources.VWResource;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class VWRouterPropertyPanel
extends VWTaskPropertyPanel {
    private VWRouterNode m_routerNode = null;
    private VWTaskTabbedPane m_tabbedPane = null;
    private VWRouterNodeConvertTwo m_tokenConverter = new VWRouterNodeConvertTwo(0);
    VWTaskNumericProperty m_isolatedRegion = null;
    VWTaskNumericProperty m_ppmPort = null;
    VWTaskNumericProperty m_rmiBacklog = null;
    JLabel m_iconLabel = null;
    JTextField m_vwServer = null;
    JTextField m_routerName = null;
    JTextField m_userName = null;
    JLabel m_userNameLabel = null;
    JLabel m_passwordLabel = null;
    JPasswordField m_password = null;
    JTextField m_localHost = null;
    JComboBox m_debugLevel = null;
    private static final boolean REQUIRED = true;
    private static final boolean NOT_REQUIRED = false;
    private static final int KEY_MASK = 0;

    public VWRouterPropertyPanel(VWRouterNode routerNode) {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.m_routerNode = routerNode;
        this.addTabbedPane();
        this.refresh(true);
    }

    public void refresh(boolean fullRefresh) {
        if (fullRefresh) {
            this.resetProperties();
        }
        this.m_iconLabel.setIcon(this.m_routerNode.getIcon32());
        this.m_isolatedRegion.setEditable(false);
        this.m_ppmPort.setEditable(false);
        this.m_rmiBacklog.setEditable(false);
        this.m_vwServer.setEditable(false);
        this.m_routerName.setEditable(false);
        this.m_localHost.setEditable(false);
        this.m_userName.setEditable(false);
        this.m_password.setEditable(false);
        this.m_debugLevel.setEnabled(false);
    }

    private void addTabbedPane() {
        this.m_tabbedPane = new VWTaskTabbedPane();
        this.addGeneralTab();
        this.addAdvancedTab();
        this.m_tabbedPane.addVWTaskPropertyChangedListener(this);
        this.add((Component)this.m_tabbedPane, "Center");
    }

    private void addGeneralTab() {
        VWTaskTabPanel mainPanel = new VWTaskTabPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConst = new GridBagConstraints();
        gbConst.fill = 2;
        gbConst.anchor = 23;
        gbConst.gridwidth = 1;
        gbConst.gridheight = 1;
        gbConst.weightx = 0.0;
        gbConst.weighty = 0.0;
        gbConst.insets = new Insets(4, 10, 0, 0);
        gbConst.gridx = 0;
        gbConst.gridy = 0;
        this.m_iconLabel = new JLabel(this.m_routerNode.getIcon32(), 2);
        mainPanel.add((Component)this.m_iconLabel, gbConst);
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setLayout(new GridBagLayout());
        this.m_routerName = new JTextField("");
        this.m_routerName.setName(VWResource.RouterName);
        panel.add((Component)new JLabel(this.m_routerName.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_routerName, (Object)FIELD_CONSTRAINTS, true);
        this.m_vwServer = new JTextField("");
        this.m_vwServer.setName(VWResource.ProcessEngine);
        panel.add((Component)new JLabel(this.m_vwServer.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_vwServer, (Object)FIELD_CONSTRAINTS, true);
        this.m_userName = new JTextField("");
        this.m_userName.setName(VWResource.UserName);
        this.m_userNameLabel = new JLabel(this.m_userName.getName() + ":");
        panel.add((Component)this.m_userNameLabel, LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_userName, (Object)FIELD_CONSTRAINTS, true);
        this.m_password = new JPasswordField("");
        this.m_password.setName(VWResource.Password);
        this.m_passwordLabel = new JLabel(this.m_password.getName() + ":");
        panel.add((Component)this.m_passwordLabel, LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_password, (Object)FIELD_CONSTRAINTS, false);
        this.m_isolatedRegion = new VWTaskNumericProperty("");
        this.m_isolatedRegion.setName(VWResource.IsolatedRegion);
        panel.add((Component)new JLabel(this.m_isolatedRegion.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_isolatedRegion, (Object)FIELD_CONSTRAINTS, true);
        gbConst.gridy = 1;
        gbConst.fill = 1;
        gbConst.gridwidth = 0;
        gbConst.weightx = 1.0;
        gbConst.weighty = 1.0;
        mainPanel.add((Component)panel, gbConst);
        this.m_tabbedPane.addTab(VWResource.General, mainPanel);
    }

    private void addAdvancedTab() {
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setLayout(new GridBagLayout());
        String[] m_debugOptions = new String[]{VWResource.Off, "1", "2", "3", "4"};
        this.m_ppmPort = new VWTaskNumericProperty("");
        this.m_ppmPort.setName(VWResource.PPMPort);
        this.m_rmiBacklog = new VWTaskNumericProperty("");
        this.m_rmiBacklog.setName(VWResource.RMIBacklog);
        this.m_localHost = new JTextField("");
        this.m_localHost.setName(VWResource.LocalHost);
        this.m_debugLevel = new JComboBox<String>(m_debugOptions);
        this.m_debugLevel.setName(VWResource.DebugLevel);
        panel.add((Component)new JLabel(this.m_ppmPort.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_ppmPort, (Object)FIELD_CONSTRAINTS, true);
        panel.add((Component)new JLabel(this.m_rmiBacklog.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_rmiBacklog, (Object)FIELD_CONSTRAINTS, false);
        panel.add((Component)new JLabel(this.m_localHost.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_localHost, (Object)FIELD_CONSTRAINTS, false);
        panel.add((Component)new JLabel(this.m_debugLevel.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((Component)this.m_debugLevel, FIELD_CONSTRAINTS);
        this.m_tabbedPane.addTab(VWResource.Advanced, panel);
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        Object aObj = event.getSource();
        boolean forwardEvent = true;
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.APPLY) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.OK) == 0) {
                forwardEvent = this.validateProperties();
                if (forwardEvent) {
                    this.applyProperties();
                }
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.RESET) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.CANCEL) == 0) {
                this.resetProperties();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.m_routerNode.displayHelp();
            }
        }
        catch (Exception ex) {
            this.m_routerNode.displayError(ex);
        }
    }

    public void applyProperties() throws Exception {
        try {
            this.m_routerNode.setRouterName(this.m_routerName.getText().trim());
            this.m_routerNode.setWorkflowServer(this.m_vwServer.getText().trim());
            this.m_routerNode.setLocalHost(this.m_localHost.getText().trim());
            this.m_routerNode.setIsolatedRegion(new Integer(this.m_isolatedRegion.getText()));
            this.m_routerNode.setPPMPort(new Integer(this.m_ppmPort.getText()));
            this.m_routerNode.setRMIBackLog(new Integer(this.m_rmiBacklog.getText()));
            this.m_routerNode.setLocalHost(this.m_localHost.getText().trim());
            this.m_routerNode.setDebugLevel((String)this.m_debugLevel.getSelectedItem());
            try {
                this.m_tokenConverter.getDString(this.m_tokenConverter.getEString(this.m_userName.getText().trim(), new String(this.m_password.getPassword())));
                this.m_routerNode.setOptions(this.m_tokenConverter.getEString(this.m_userName.getText().trim(), new String(this.m_password.getPassword())));
            }
            catch (Exception e) {
                VWDebug.logError("Error applying user name password: " + e.getLocalizedMessage());
            }
            this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void resetProperties() {
        this.m_routerName.setText(this.m_routerNode.getRouterName());
        this.m_vwServer.setText(this.m_routerNode.getWorkflowServer());
        this.m_isolatedRegion.setText(this.m_routerNode.getIsolatedRegion().toString());
        this.m_ppmPort.setText(this.m_routerNode.getPPMPort().toString());
        this.m_rmiBacklog.setText(this.m_routerNode.getRMIBacklog().toString());
        this.m_localHost.setText(this.m_routerNode.getLocalHost());
        this.m_debugLevel.setSelectedItem(this.m_routerNode.getDebugLevel());
        String userName = null;
        String password = null;
        try {
            VWAuthItem item = this.m_tokenConverter.getDString(this.m_routerNode.getOptions());
            if (item != null) {
                userName = item.getName();
                password = item.getPassword();
            }
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
        if (userName == null) {
            userName = "";
        } else if (userName.compareTo("\"\"") == 0) {
            userName = "";
        }
        if (password == null) {
            password = "";
        } else if (password.compareTo("\"\"") == 0) {
            password = "";
        }
        this.m_userName.setText(userName);
        this.m_password.setText(password);
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 2));
    }

    private boolean validateProperties() {
        try {
            if (this.m_routerName.getText().trim().indexOf(" ") != -1) {
                throw new VWException("vw.apps.taskman.router", "Invalid router name: Router names may not contain spaces.");
            }
            this.m_tabbedPane.validateProperties();
        }
        catch (VWException e) {
            this.m_routerNode.displayError(e);
            return false;
        }
        return true;
    }
}

